<?php

namespace App\Http\Controllers\Therapists;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Http\Controllers\Controller;
use App\Http\Resources\Web\AppointmentSchedulesResource;
use App\Http\Resources\Web\AppointmentTypesResource;
use App\Http\Resources\Web\TherapistsResource;
use App\Models\AppointmentSchedule;
use App\Models\AppointmentType;
use App\Models\BookAppointment;
use App\Models\Gateway;
use App\Models\Therapist;

class TherapistProfileController extends Controller
{
    public function __construct()
    {

    }

    public function myProfile(Request $request)
    {
        $user = auth()->user();
        $therapist = $user->therapist;
        $therapist = Therapist::withChildrens()->active()->withAll()->where('id', $therapist->id)->first();
        if (!$therapist) {
            abort(404);
        }
        $therapist = new TherapistsResource($therapist);
        $appointment_types = AppointmentType::active()->get();
        $appointment_types = AppointmentTypesResource::collection($appointment_types);
        return Inertia::render('Therapists/Profile', [
            'therapist' => $therapist,
            'appointment_types' => $appointment_types
        ]);
    }
    public function profile(Request $request)
    {
        $therapist = Therapist::withChildrens()->active()->approved()->withAll()->where('user_name', $request->user_name)->first();
        if (!$therapist) {
            abort(404);
        }
        $therapist = new TherapistsResource($therapist);
        $appointment_types = AppointmentType::active()->get();
        $appointment_types = AppointmentTypesResource::collection($appointment_types);
        return Inertia::render('Therapists/Profile', [
            'therapist' => $therapist,
            'appointment_types' => $appointment_types
        ]);
    }

    public function reviews(Request $request)
    {
        $therapist = Therapist::withChildrens()->active()->approved()->withAll()->where('user_name', $request->user_name)->first();
        if (!$therapist) {
            abort(404);
        }
        $therapist = new TherapistsResource($therapist);
        return Inertia::render('Therapists/Reviews', [
            'therapist' => $therapist
        ]);
    }

    public function bookAppointment(Request $request, $user_name)
    {
        $therapist = Therapist::where('user_name', $user_name)->first();
        $therapist_id = $therapist->id;
        $appointment_type = AppointmentType::select('id', 'is_schedule_required')->where('type', $request->type)->first();
        $appointment_type_id = $appointment_type->id;
        $day = strtolower(Date('l'));
        $date = today();
        if ($appointment_type->is_schedule_required) {
            $schedule = AppointmentSchedule::with('appointment_type')->with('schedule_slots')->where('therapist_id', $therapist_id)->where('appointment_type_id', $appointment_type_id)->where('day', $day)->first();
        } else {
            $schedule = AppointmentSchedule::with('appointment_type')->with('schedule_slots')->where('therapist_id', $therapist_id)->where('appointment_type_id', $appointment_type_id)->first();
        }
        if ($schedule) {
            $scheduleSlots = $schedule->schedule_slots;
            if (count($scheduleSlots) > 0) {
                foreach ($scheduleSlots as $scheduleSlot) {
                    $is_disabled = BookAppointment::where('therapist_id', $therapist_id)
                    ->whereDate('date', $date)
                    ->where('is_paid', 1)
                    ->where(function ($q) use ($scheduleSlot) {
                        $q->where(function ($z) use ($scheduleSlot) {
                            $z->where('start_time',$scheduleSlot->start_time);
                            $z->where('end_time', $scheduleSlot->end_time);
                        });
                    })->count();

                    $scheduleSlot['is_disabled'] = $is_disabled;
                }
            }
            $schedule = new AppointmentSchedulesResource($schedule);
        } else {
            $schedule = null;
        }
        $gateways = Gateway::where('status', 1)->get();

        return Inertia::render('Therapists/BookAppointment', [
            'schedule' => $schedule,
            'therapist_id' => $therapist_id,
            'therapist' => $therapist,
            'appointment_type_name' => $appointment_type->display_name,
            'appointment_type_id' => $appointment_type_id,
            'is_schedule_required' => $appointment_type->is_schedule_required,
            "gateways" => $gateways
        ]);
    }
}
